/*
   The program "calls" adder.exe as an external process.
   This is a baby example of parallel programming, or a very
   simplified example of how a "remote procedure call" might work.
*/
#include <windows.h>
#include <stdio.h>

/* function prototype */
void printError(char* functionName);

int main( int argc, char *argv[])
{
   int i;
   char commandLine[100];
   PROCESS_INFORMATION processInfo;

   STARTUPINFO startInfo;
   ZeroMemory(&startInfo, sizeof(startInfo));
   startInfo.cb = sizeof(startInfo);

   /* set up the command line */
   sprintf(commandLine, "%s", "adder.exe");
   /* put command-line arguments of this process on the command-line of the child process.*/
   for (i = 0; i < argc; i++)
      sprintf(commandLine, "%s %s", commandLine, argv[i]);

   /* "call" the adder process */
   if( !CreateProcess(NULL, commandLine, NULL, NULL, TRUE,
                      NORMAL_PRIORITY_CLASS,
                      NULL, NULL, &startInfo, &processInfo) )
   {
       printError("CreateProcess");
   }

   /* wait for the "call" to adder to return */
   WaitForSingleObject(processInfo.hProcess, INFINITE);

   /* read the result from the adder process's exit value */
   int result;
   GetExitCodeProcess(processInfo.hProcess, (LPDWORD)&result);

   /* write the result to stdout */
   printf("%d", result);

   /* close all the handles */
   CloseHandle(processInfo.hThread);
   CloseHandle(processInfo.hProcess);

   return 0;
}



/****************************************************************
   The following function can be used to print out "meaningful"
   error messages. If you call a Win32 function and it returns
   with an error condition, then call this function right away and
   pass it a string containing the name of the Win32 function that
   failed. This function will print out a reasonable text message
   explaining the error and then (if chosen) terminate the program.
*/
void printError(char* functionName)
{
   LPVOID lpMsgBuf;
    int error_no;
    error_no = GetLastError();
    FormatMessage(
         FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
         NULL,
         error_no,
         MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
         (LPTSTR) &lpMsgBuf,
         0,
         NULL
    );
    // Display the string.
    fprintf(stderr, "\n%s failed on error %d: ", functionName, error_no);
    fprintf(stderr, (const char*)lpMsgBuf);
    // Free the buffer.
    LocalFree( lpMsgBuf );
    //ExitProcess(1);  // terminate the program
}//printError
